# Contract Scheduling

## Overview
This project implements algorithms for the **contract scheduling problem** with learning-augmented objectives.  
The goal is to choose an optimal phase parameter `λ ∈ [1,2)` for doubling schedules under different evaluation metrics.

## Functionality

1. **Core Model**:
   - `f_X_T(T, λ)`: Performance ratio at horizon `T` for schedule `X_λ`.
   - `ell_X_T(T, λ)`: Completed contract length at time `T`.
   - `lam_for_jump(T_next, k)`: Phase-aligned λ corresponding to jump `T_next = λ·2^k`.

2. **Weight Functions**:
   - `w_linear(T, y, δ)`: Triangular window centered at prediction `y`.
   - `w_gauss(T, y, δ)`: Gaussian window (truncated to `[y(1−δ), y(1+δ)]`).

3. **Distributions (μ)**:
   - `make_mu_grid(y, δ, mu_type)`: Builds a normalized probability distribution for evaluating **expected ratios** and **CVaR**.  
     - `mu_type="gaussian"`: Gaussian prior.  
     - `mu_type="linear"`: Triangular prior.

4. **Optimization Objectives**:
   - **MAX**: Minimize maximum weighted distance to 2.  
   - **AVG**: Minimize average weighted distance to 2.  
   - **CVaR**: Maximize Conditional Value-at-Risk objective at level α.  
   - Implemented via `find_lambda(...)`.

5. **Metrics**:
   - `avg_ratio(...)`: Average performance ratio over `[y(1−δ), y(1+δ)]`.  
   - `E_ratio(...)`: Expected performance ratio under μ.  
   - `E_length(...)`: Expected completed length under μ.  
   - `win_rate(...)`: Probability that one algorithm outperforms a baseline.

6. **Experiment Driver**:
   - `contract_experiment(...)`: Runs Monte Carlo trials across random predictions `y ~ Uniform(y_low, y_high)` and uncertainty ranges `δ`.  
   - Evaluates **MAX**, **AVG**, **CVaR** (with multiple α), and baselines (**PO**, **δT**).  
   - Returns averages and bootstrap confidence intervals.

7. **Reporting**:
   - `print_contract_results(...)`: Pretty-prints results with means and confidence intervals.

## Usage
Run the script with:
```bash
python contract_scheduling.py

### License
This project is under the [MIT License](https://opensource.org/licenses/MIT).
